/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.json.text.rules;

import com.aptana.editor.common.text.rules.ExtendedWordRule;
import com.aptana.editor.json.text.rules.JSONEscapeSequenceDetector;
import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;

public class JSONEscapeSequenceRule
extends ExtendedWordRule {
    private static final String REGEXP = "\\\\([\"\\/bfnrt]|u[0-9a-fA-F]{4}|.)";
    private static Pattern pattern;

    private static synchronized Pattern getPattern() {
        if (pattern == null) {
            pattern = Pattern.compile(REGEXP);
        }
        return pattern;
    }

    public JSONEscapeSequenceRule(IToken token) {
        super((IWordDetector)new JSONEscapeSequenceDetector(), token, false);
    }

    protected boolean wordOK(String word, ICharacterScanner scanner) {
        return JSONEscapeSequenceRule.getPattern().matcher(word).matches();
    }
}

